/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Wen Mar 20 10:17:10 2007
*  Last modified   :  %modify_time%
*/
/** @file 
*  \brief A brief description of this module 
*
*  \version CE2_TST_DH.c#1:csrc:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************* Include Files ****************/

#include <memory.h>
#include "CryptoEngine2.h"
#include "CE2_TST_DH.h"
#include "CE2_TST_Common.h"

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

/**********/
/* PKCS#3 */
/**********/
TST_DH_TestDataStructPKCS3 TST_DH_Acceptance_PKCS3_TestDataStruct[] = 
{
  { 
    {"Acceptance test - DH PKCS#3/Prime-512/Generator-512/l=0"},
      /*TST_Generator - G*/
    {0xd4,0x07,0xa9,0x80,0xaf,0xc2,0x7a,0x5b,0x61,0x22,0x76,0x29,0x1d,0x65,0x52,0x59,
    0x7f,0x4f,0x17,0x7a,0xa1,0xea,0x04,0x02,0x8c,0x8b,0x01,0x11,0x72,0x2b,0x4d,0xc3,
    0x78,0xc0,0x08,0x11,0x01,0xcd,0x45,0xab,0xb3,0x05,0x56,0xcd,0x72,0x52,0x16,0x7c,
    0x74,0xf1,0x00,0x77,0xa4,0xf3,0x31,0x83,0x50,0xc3,0xed,0x3b,0xb5,0xb5,0x5d,0x43},  
    /*TST_GeneratorSize;*/
    64*sizeof(DxUint8_t),
    /*TST_Prime - P*/
    {0xfc,0xf6,0xd3,0x9e,0x31,0x88,0x25,0x66,0x30,0x74,0x1c,0x03,0x85,0x6e,0xbd,0xea,
    0x02,0x01,0x0b,0x77,0x43,0x35,0xfe,0x57,0x9c,0x60,0xd5,0x24,0x22,0xbe,0x99,0xeb,
    0x4f,0x8f,0x95,0x77,0xdc,0x47,0x6a,0x5e,0x31,0x21,0x6e,0x9c,0x00,0x1b,0x55,0xa7,
    0xed,0xc4,0xcd,0xf2,0x31,0xd2,0x44,0x60,0x10,0xd4,0xb2,0x6c,0xb6,0xf4,0xb3,0x73},
    /*TST_PrimeSize*/
    64*sizeof(DxUint8_t),
    /*TST_L*/
    0,        
  },  
  {
    {"Acceptance test - DH PKCS#3/Prime-1024/Generator-1024/l=0"},
      /*TST_Generator - G*/
    {0xc4,0x3b,0x36,0xc8,0xe7,0xa9,0x60,0xea,0x35,0x80,0x6a,0x02,0x6a,0x02,0x02,0xcb,
    0x21,0x24,0x3d,0xb8,0x3d,0x01,0x76,0x63,0x8a,0xee,0x95,0x50,0x94,0x1d,0x6f,0x0c,
    0x6f,0x84,0x17,0x16,0x24,0x00,0x27,0xe2,0x01,0x8a,0xa8,0xa4,0xdf,0x7e,0xde,0xb4,
    0x49,0x20,0x2c,0x8f,0x34,0x3b,0xa1,0x4e,0x6b,0x02,0x23,0x11,0x42,0x9a,0x9c,0xba,
    0x22,0x15,0x06,0x1c,0x26,0x39,0x1c,0xdb,0x43,0xd3,0x2c,0x75,0x96,0xaf,0x97,0xcf,
    0xa9,0x32,0xa1,0xa7,0x3f,0x90,0xa9,0xa8,0x1d,0xb8,0x48,0xcc,0x2e,0x68,0xc1,0xf1,
    0x71,0xd2,0xfb,0x4f,0xda,0x9c,0x89,0x02,0xea,0x89,0x9b,0xa2,0xe9,0x33,0xc4,0xfe,
    0x7a,0x31,0x39,0x71,0x12,0x18,0xb9,0xbe,0x33,0x10,0xcf,0x1b,0x65,0xcb,0xc1,0x73},  
    /*TST_GeneratorSize;*/
    128*sizeof(DxUint8_t),
    /*TST_Prime - P*/
    {0xc4,0xac,0x0a,0xd9,0x6a,0xf5,0xb1,0x93,0x46,0x43,0xac,0x5b,0x2e,0x45,0x38,0x29,
    0x4e,0x24,0xde,0x8f,0x80,0x28,0x6c,0x4a,0xef,0xcb,0xc2,0x07,0xe5,0xae,0xec,0x4f,
    0x9a,0x1b,0x1b,0x61,0x35,0xdb,0xf9,0x88,0x83,0x61,0x4e,0xca,0x8e,0x82,0x43,0xf9,
    0x56,0x9f,0x4c,0xb0,0x28,0xbc,0xa9,0x9a,0x23,0x05,0xbd,0x08,0x7d,0xc6,0x3b,0x62,
    0x8f,0x2a,0x96,0x30,0xcf,0x29,0x6f,0x1c,0x18,0x54,0x57,0x9f,0xcb,0xf3,0xb0,0x85,
    0xb9,0xce,0xea,0xce,0x71,0x7a,0x16,0x05,0xb3,0xeb,0xf4,0xf6,0x99,0xd2,0x7c,0xe8,
    0x0e,0x36,0x01,0x3f,0x87,0x6c,0x4a,0xfc,0x45,0x67,0x09,0x5c,0xcb,0x09,0x9a,0x5b,
    0x96,0x61,0xd3,0x35,0x1a,0x04,0x07,0xa8,0x68,0xe4,0xc4,0xb1,0x3b,0x11,0xd7,0xa3},
    /*TST_PrimeSize*/
    128*sizeof(DxUint8_t),
    /*TST_L*/
    0,        
    },
    { 
      {"Acceptance test - DH PKCS#3/Prime-2048/Generator-2048/l=0"},
        /*TST_Generator - G*/
      {0xc9,0x16,0xa6,0x54,0x91,0xa7,0x1c,0xdf,0x9b,0xf9,0x59,0x07,0x95,0x06,0x4f,0xfa,
      0x95,0x79,0xc5,0x20,0x47,0xa4,0x75,0xce,0x49,0xb5,0x3c,0xfa,0x91,0xd4,0xd2,0xb5,
      0xe5,0x6b,0x36,0x24,0x5f,0x90,0x8e,0xfb,0x7a,0x1b,0x41,0xf7,0x18,0x41,0xfc,0x7b,
      0xa5,0xb4,0xc3,0xe1,0x71,0xb4,0x66,0x54,0x02,0x0a,0xd3,0xd9,0xd2,0x9d,0xe6,0x18,
      0x6d,0x2a,0xb7,0xdb,0x45,0xbe,0xc1,0x83,0x7f,0x94,0x5b,0xd7,0xd8,0x98,0xd2,0xcf,
      0x54,0x38,0x39,0xda,0x90,0x86,0xcc,0xab,0x0f,0x15,0xf8,0xb8,0xbf,0xde,0x50,0x07,
      0x74,0x45,0x84,0x4c,0x2f,0x08,0xb1,0x2f,0x40,0x49,0x9c,0xaf,0xb6,0xd1,0x6c,0xe3,
      0x45,0xbf,0xf1,0x63,0xcc,0x77,0x66,0x5d,0x45,0x35,0xb9,0x0a,0xac,0x74,0x14,0x91,
      0x64,0x1b,0x34,0x50,0xb4,0xa0,0x1e,0xd9,0xa9,0x62,0x56,0x57,0xcb,0x73,0x3c,0x96,
      0x5f,0x86,0x7f,0xc3,0x66,0xbf,0xac,0x79,0x21,0x51,0x14,0x3f,0x37,0x29,0xbe,0x96,
      0xc8,0xee,0xf1,0xaf,0x4e,0xc7,0x9f,0x83,0x20,0xe7,0xb5,0xb2,0x52,0x57,0xcc,0xa8,
      0xb0,0xf2,0x4d,0x88,0x3e,0x71,0xfb,0xd7,0x45,0x4d,0x96,0x0b,0xcb,0x24,0x0a,0x88,
      0x4f,0xaf,0xe8,0x96,0x79,0x87,0x14,0xf8,0x1e,0x3d,0xf7,0x2c,0x48,0xf7,0x0e,0x52,
      0x4e,0x3d,0xcb,0xeb,0x57,0x54,0xb9,0x90,0xe1,0x14,0x5c,0x36,0x7d,0xc0,0xa3,0x5f,
      0xf4,0xfd,0xf6,0x33,0x23,0x7e,0xf2,0xd0,0xff,0x0d,0xe0,0xe2,0xa3,0xcc,0x81,0x86,
      0xbc,0xde,0x67,0x83,0x03,0xd6,0xfa,0x5b,0x42,0xd3,0x1f,0xfe,0xd2,0x0f,0x2b,0x1b},  
      /*TST_GeneratorSize;*/
      256*sizeof(DxUint8_t),
      /*TST_Prime - P*/
      {0xce,0xd3,0x02,0x09,0x7d,0xe5,0x34,0xf5,0x3f,0x14,0x2e,0x7b,0x3e,0x15,0x4c,0x66,
      0x2c,0xe1,0xf0,0xb7,0x40,0x72,0x68,0xfa,0xad,0xa6,0xd5,0xd9,0x55,0x1e,0x7e,0xfd,
      0x06,0xbc,0x4f,0xb8,0x27,0xe9,0x22,0x3d,0x17,0xfa,0x4d,0x8c,0x8b,0x8e,0xce,0xf6,
      0xc9,0x49,0x38,0x74,0xa2,0x77,0x3b,0x9a,0xe1,0xc0,0xa7,0xc8,0x83,0xf9,0xdc,0xa7,
      0x9a,0x12,0xc5,0x19,0x5c,0xfb,0x40,0x0c,0x08,0x57,0xa1,0xf7,0x8d,0xf2,0x10,0x83,
      0xe8,0xe7,0x8a,0xc1,0x0c,0x59,0xa1,0xa3,0x77,0xb1,0x9f,0x0d,0x0f,0xf8,0x27,0xdd,
      0xdc,0xed,0xbf,0x04,0x91,0xa3,0x00,0x19,0x08,0x2d,0x7c,0xc9,0xda,0xfb,0x05,0x31,
      0xf5,0x34,0x0d,0xaa,0xd3,0xbb,0xc0,0x5b,0xfb,0xad,0x32,0x6b,0x98,0x00,0x17,0x01,
      0x39,0x61,0x0e,0x03,0x2e,0xf6,0x60,0x30,0x7b,0xb9,0xeb,0x39,0x60,0x1b,0xc4,0x7f,
      0xe5,0xcb,0x5f,0xc3,0xb0,0x79,0xdb,0x04,0xd2,0x9a,0x11,0x95,0x3e,0xa4,0x33,0x61,
      0x8e,0x94,0x22,0x9b,0x0a,0xd0,0xfb,0xda,0x07,0xc7,0x34,0xfb,0xa9,0x94,0xc8,0x31,
      0x03,0xe1,0x92,0xac,0x86,0xfc,0x45,0xe3,0x79,0x0b,0x9e,0x29,0x63,0xe8,0xcf,0x26,
      0x05,0xb3,0x6e,0xa9,0xae,0x9d,0xe3,0xdc,0x03,0x43,0x26,0xdf,0x7e,0x8b,0xae,0xcb,
      0xe8,0x09,0x04,0x25,0xdd,0x42,0xb8,0x59,0x44,0xec,0xc1,0xc7,0xbf,0x78,0x50,0x31,
      0xec,0x6e,0xa5,0x5f,0xe4,0x4f,0x79,0x7b,0xf3,0xbf,0x03,0xd3,0xa9,0x7b,0x7c,0x70,
      0xa2,0x5f,0xdb,0x86,0x96,0xfa,0xd1,0x3f,0x43,0xc5,0xd2,0x2a,0xf8,0xf3,0x3c,0x7b},
      /*TST_PrimeSize*/
      256*sizeof(DxUint8_t),
      /*TST_L*/
      0,        
    },
    { 
      {"Acceptance test - DH PKCS#3/Prime-512/Generator-512/l=10"},
        /*TST_Generator - G*/
      {0xc4,0x0d,0x90,0xd4,0xac,0x8d,0xba,0x55,0xe9,0x0d,0xef,0x2a,0xa9,0x23,0x87,0x79,
      0x67,0x8a,0x8f,0x7a,0xb9,0xa4,0x81,0x76,0xc4,0xa9,0x6c,0x99,0xe2,0xbc,0x6b,0x40,
      0x96,0xd0,0xbf,0xd7,0x1c,0x31,0xe0,0x89,0xd8,0x36,0x5b,0xb3,0xc7,0xc2,0xbf,0x4f,
      0x1c,0xc7,0x6a,0xf7,0xa5,0x26,0xc7,0x26,0x83,0x13,0xa2,0x5b,0xd1,0x92,0xff,0x61},  
      /*TST_GeneratorSize;*/
      64*sizeof(DxUint8_t),
      /*TST_Prime - P*/
      {0xe0,0x37,0x1c,0x4c,0xff,0x1f,0x66,0x2e,0xe5,0x63,0x1c,0x97,0x4f,0x3e,0x57,0xc5,
      0x21,0x49,0x2f,0xd8,0xfe,0x33,0xef,0x07,0x95,0x08,0x99,0x9b,0x28,0xb3,0x59,0x6a,
      0x8e,0x8f,0x23,0x81,0xb6,0x98,0x73,0x64,0x07,0xa9,0x48,0xc3,0x65,0x2b,0xb8,0xee,
      0x55,0xcf,0x87,0xe1,0xca,0xe7,0xc4,0x5b,0x28,0xd2,0x08,0x02,0xa6,0x2b,0x7e,0x07},
      /*TST_PrimeSize*/
      64*sizeof(DxUint8_t),
      /*TST_L*/
      10,       
      },   
      {
        {"Acceptance test - DH PKCS#3/Prime-1024/Generator-1024/l=11"}, 
          /*TST_Generator - G*/
        {0x33,0x38,0xa5,0x92,0xda,0x5b,0xb1,0x69,0x8b,0x92,0x44,0x87,0x7b,0xcb,0x9d,0x1a,
        0x84,0xf4,0x07,0x57,0x44,0xe6,0xa1,0x1d,0xb6,0x50,0xd3,0x41,0xc7,0x89,0x08,0x06,
        0x53,0xdc,0x46,0x4b,0xa1,0xb7,0x0e,0x02,0x49,0x37,0xb5,0x4c,0xb0,0xb4,0x58,0x38,
        0x35,0xc9,0x94,0xca,0xcb,0x6e,0x0b,0xa9,0xfc,0xb9,0xb8,0x73,0x0e,0x6d,0xdd,0x13,
        0xf1,0xfb,0xe7,0xa6,0x21,0x2b,0x63,0xe5,0x0d,0xe8,0x77,0x7e,0x5c,0xfb,0xd4,0x02,
        0x12,0x31,0xb8,0x20,0x42,0x13,0x6b,0xdf,0x0e,0xdb,0xbb,0x0e,0xb6,0xd5,0xaa,0x94,
        0x62,0xb1,0x48,0x9f,0x18,0xf8,0xab,0x59,0x9a,0x36,0x28,0x99,0x56,0xcd,0xef,0xfa,
        0x42,0x46,0xfb,0xe5,0x15,0xa3,0x6a,0x34,0x6b,0xd3,0xc6,0xc1,0x6c,0x6c,0x7c,0x4d},  
        /*TST_GeneratorSize;*/
        128*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xbd,0xc0,0x4f,0xd0,0x12,0x80,0x59,0xe8,0xd5,0x10,0x1b,0x76,0x2f,0xb6,0x0a,0x03,
        0xfe,0xa5,0xcf,0x0c,0xd6,0xc5,0x8d,0xa8,0x71,0xc6,0xa1,0xd9,0x2c,0x1a,0x8f,0xcc,
        0xc5,0xb4,0xde,0xe7,0x80,0x59,0x99,0x22,0x18,0x99,0x99,0x4b,0x0f,0x2a,0x6d,0x42,
        0xe5,0xd9,0x3a,0x22,0x4c,0x72,0x30,0x6b,0x51,0xe2,0x95,0x6f,0x5d,0x3f,0x63,0x84,
        0xbd,0x72,0x41,0x1c,0x1f,0xcc,0xad,0x70,0x1c,0x61,0x12,0xd8,0xfb,0xcb,0x6c,0x7e,
        0x9e,0x0c,0xff,0x30,0xa1,0xa1,0xc1,0x99,0xb7,0x08,0x67,0xa2,0x03,0x83,0x05,0xbf,
        0x52,0x7d,0x83,0xf8,0x05,0x1e,0x1b,0x64,0x6f,0xc5,0xac,0xc4,0xcf,0x42,0xbb,0x7c,
        0x4f,0x89,0xfa,0x7c,0x2e,0x7c,0xdf,0x6d,0x32,0x75,0xff,0xba,0x4e,0x62,0xdc,0xd1},
        /*TST_PrimeSize*/
        128*sizeof(DxUint8_t),
        /*TST_L*/
        11,       
      },
      { 
        {"Acceptance test - DH PKCS#3/Prime-2048/Generator-2048/l=12"}, 
          /*TST_Generator - G*/
        {0xc0,0x27,0xaf,0xaf,0x57,0x1a,0x9e,0xd6,0x9a,0x24,0x2f,0xef,0x31,0x30,0x58,0xba,
        0x14,0x77,0xdc,0x60,0x11,0x43,0x10,0x4a,0x80,0xe3,0xd8,0xa6,0xe3,0x00,0x11,0x87,
        0x24,0x8f,0x3c,0xf6,0x48,0x4f,0xfd,0xd7,0x22,0x4c,0x76,0xb0,0xaa,0xb4,0x22,0xe9,
        0xd4,0xb7,0xed,0x9a,0x1a,0xea,0xa2,0x01,0x57,0x52,0xb0,0x9e,0xae,0x3e,0x45,0x3a,
        0x1e,0x56,0x5b,0xda,0x4d,0x35,0x67,0x2a,0xb8,0x9d,0x77,0xb0,0xa8,0x5e,0xc8,0xd4,
        0x06,0x82,0x5f,0x15,0x82,0xe5,0x45,0x8f,0xf6,0x9a,0xab,0x5c,0x96,0x38,0xcc,0x19,
        0x94,0x2d,0xc5,0x25,0x40,0x24,0x4c,0x3f,0xc7,0x8d,0x08,0x5b,0x68,0x21,0xb2,0xb6,
        0x4f,0x1a,0x1f,0x42,0x3b,0xf4,0x9c,0x0b,0x98,0x10,0xd5,0x56,0xac,0x88,0x4b,0x8c,
        0x39,0x79,0xde,0xf7,0xca,0xfc,0x31,0xaf,0x67,0x91,0x0b,0xb7,0xcd,0x67,0x01,0x72,
        0x8a,0x52,0xc1,0xf5,0x98,0x97,0x47,0x36,0x23,0xab,0x8e,0xf5,0x8a,0x30,0xf4,0x62,
        0x07,0x55,0x57,0x7e,0xf9,0xa1,0x76,0x4c,0xa8,0xb0,0xe0,0xc9,0xb1,0xa0,0x86,0x5e,
        0xc9,0x13,0x36,0xe7,0xdd,0x02,0x89,0xf6,0x0b,0x0c,0xf4,0x49,0xf7,0xa6,0xcb,0x03,
        0xb7,0x80,0x54,0xbf,0x5b,0xeb,0x6b,0x92,0xfd,0x62,0xe0,0x2a,0xb0,0x6c,0xeb,0x6d,
        0x34,0x1d,0xe1,0x89,0x92,0xcb,0x21,0xbc,0x53,0x45,0x1b,0x13,0xa8,0xe2,0xb6,0x50,
        0xd4,0xf5,0x3a,0x44,0x52,0x5c,0x10,0x08,0x0a,0x95,0xfc,0x6a,0x2c,0x92,0xc0,0x21,
        0x73,0xc5,0xab,0x6e,0x94,0x3e,0x0f,0x6b,0xd2,0xa4,0x85,0xea,0xd9,0x20,0x98,0xd5},  
        /*TST_GeneratorSize;*/
        256*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xd3,0xa2,0x3a,0xbc,0xcc,0xa2,0xe7,0xc3,0x39,0x2a,0x8b,0x5c,0x8a,0x3c,0x29,0x39,
        0xa1,0xef,0xf4,0xe2,0x06,0x79,0xae,0x2b,0xca,0xde,0xad,0x84,0x91,0xcd,0xe6,0x3a,
        0x07,0x24,0xaa,0x4d,0xa0,0x02,0xea,0xe2,0xb2,0xd6,0xcb,0x3a,0xf3,0x2b,0x8c,0x92,
        0xaa,0xea,0x47,0x9f,0x5b,0xc7,0xf8,0xfe,0xf8,0x09,0x6e,0x1a,0x3a,0xcc,0x22,0x9b,
        0xb5,0xe2,0x6b,0x4e,0xab,0x67,0xc6,0x25,0x24,0xd7,0x17,0x92,0x73,0x37,0xd1,0x2b,
        0x90,0xab,0xa0,0xeb,0xf9,0x2e,0x1d,0xe7,0xc3,0x29,0x5d,0x78,0x46,0x0f,0xf4,0x2b,
        0xb1,0xa5,0x71,0xfb,0x43,0xba,0x19,0xa6,0x59,0xca,0x20,0xc2,0x2f,0x33,0x0e,0xae,
        0xec,0xcd,0x23,0x1a,0x54,0x83,0xe7,0x7a,0x83,0x58,0xc5,0xc2,0x71,0xb3,0x9e,0xad,
        0x64,0x3f,0x4f,0x63,0xb4,0xf4,0xa5,0x6f,0xa4,0x66,0x10,0x62,0x00,0xa7,0x30,0x2f,
        0x7d,0x37,0x2a,0x97,0xc0,0xc6,0x9b,0x13,0x2d,0x11,0x95,0x20,0x2c,0x2c,0x68,0x81,
        0x70,0x30,0xf0,0xa7,0x45,0x12,0x4c,0xbf,0x99,0xa3,0xd3,0x70,0x26,0x00,0x2e,0x4a,
        0xc6,0xdc,0x59,0xe9,0xdf,0x1c,0x1f,0x1a,0xd5,0x02,0xe5,0xda,0xe7,0x5f,0xb4,0x4d,
        0x39,0x82,0xf0,0x81,0xd1,0x6b,0xd8,0xda,0xf5,0xa4,0x33,0x53,0xe9,0x9a,0x75,0x5a,
        0x8e,0x95,0xcb,0x8a,0xcf,0x82,0x5b,0x8d,0x65,0x9b,0x7d,0x72,0x64,0x57,0xfa,0x7a,
        0xdb,0x3e,0x5f,0x5b,0xa5,0x92,0x14,0xea,0xa3,0xbb,0xf6,0xa9,0x70,0x41,0xfa,0x8b,
        0xe9,0x80,0x75,0xe7,0xa6,0x5d,0xdf,0x54,0xee,0x10,0x41,0x6c,0x5b,0xbc,0x64,0xa1},
        /*TST_PrimeSize*/
        256*sizeof(DxUint8_t),
        /*TST_L*/
        12,       
        },      
};

/***********/
/* ANSI942 */
/***********/
TST_DH_TestDataStructANSI942 TST_DH_Acceptance_ANSI942_TestDataStruct[] = 
{
  { 
    {"Acceptance test - DH ANSI9.42/Prime-512/Generator-512/Q-512/\n  DH_HASH_SHA1_mode/DH_ASN1_Der_mode"}, 
      /*TST_Generator - G*/
    {0xd6,0x7a,0x0c,0x91,0x78,0x14,0xad,0x34,0xf0,0xa8,0xa4,0x41,0x36,0x43,0x40,0xe6,
    0xf2,0xc4,0x74,0x05,0xda,0x85,0x39,0x81,0x4e,0xab,0x68,0xd6,0xba,0x86,0xb9,0xa8,
    0x64,0x78,0x7e,0x3d,0x1e,0xc3,0xb0,0x2f,0x83,0xf7,0x9a,0x15,0x0f,0x09,0xa4,0xdb,
    0x28,0x50,0x93,0x36,0x7c,0x73,0xb0,0xf5,0xc9,0xfb,0x61,0x61,0xcb,0xed,0x73,0x87},  
    /*TST_GeneratorSize;*/
    64*sizeof(DxUint8_t),
    /*TST_Prime - P*/
    {0xf2,0xf4,0xd0,0x43,0xc6,0xee,0x9d,0xb6,0x00,0x49,0x9a,0x7b,0x7d,0x5f,0x63,0x65,
    0x4e,0x91,0xa7,0x36,0xe4,0x75,0x04,0x80,0xb9,0x04,0xa4,0xf8,0x9d,0xde,0x51,0x4e,
    0xbf,0xdc,0x7b,0x79,0xdf,0xe3,0x4f,0xd1,0xd5,0x3f,0xb8,0x75,0xbe,0xd4,0xaa,0x9a,
    0x6b,0x37,0xdb,0x58,0xe1,0x95,0xe1,0xfa,0xdf,0xbc,0x9e,0x31,0xc5,0xb4,0x6b,0xcf},
    /*TST_PrimeSize*/
    64*sizeof(DxUint8_t),
    /*TST_Q*/
    {0x92,0xbe,0x5a,0xf9,0x2b,0xf7,0x86,0x7d,0x26,0xd2,0x3c,0x06,0x11,0x23,0x67,0xb4,
    0xfc,0x3e,0x45,0x30,0x22,0x18,0xe4,0xac,0xa1,0xbe,0xea,0x60,0xc9,0x13,0x02,0xa9,
    0xbb,0xf1,0x2e,0x89,0xf3,0x18,0xd4,0x20,0xbb,0x02,0x93,0x07,0x7c,0xf1,0x78,0x4f,
    0xbf,0x48,0x93,0x38,0x7b,0x11,0x10,0x2b,0xdf,0xe0,0x9a,0x36,0x57,0xc4,0x83,0xe7},
    /*TST_QSize*/
    64*sizeof(DxUint8_t),   
    /*TST_hashFunc*/
    CE2_DH_HASH_SHA1_mode,
    /*TST_DerFunc_mode*/
    CE2_DH_ASN1_Der_mode,
    /*TST_KeyLenInBits*/
    128,
  },  
  {
    {"Acceptance test - DH ANSI9.42/Prime-1024/Generator-1024/Q-1024/\n  DH_HASH_SHA1_mode/DH_ASN1_Der_mode"},
      /*TST_Generator - G*/
    {0xc4,0x3b,0x36,0xc8,0xe7,0xa9,0x60,0xea,0x35,0x80,0x6a,0x02,0x6a,0x02,0x02,0xcb,
    0x21,0x24,0x3d,0xb8,0x3d,0x01,0x76,0x63,0x8a,0xee,0x95,0x50,0x94,0x1d,0x6f,0x0c,
    0x6f,0x84,0x17,0x16,0x24,0x00,0x27,0xe2,0x01,0x8a,0xa8,0xa4,0xdf,0x7e,0xde,0xb4,
    0x49,0x20,0x2c,0x8f,0x34,0x3b,0xa1,0x4e,0x6b,0x02,0x23,0x11,0x42,0x9a,0x9c,0xba,
    0x22,0x15,0x06,0x1c,0x26,0x39,0x1c,0xdb,0x43,0xd3,0x2c,0x75,0x96,0xaf,0x97,0xcf,
    0xa9,0x32,0xa1,0xa7,0x3f,0x90,0xa9,0xa8,0x1d,0xb8,0x48,0xcc,0x2e,0x68,0xc1,0xf1,
    0x71,0xd2,0xfb,0x4f,0xda,0x9c,0x89,0x02,0xea,0x89,0x9b,0xa2,0xe9,0x33,0xc4,0xfe,
    0x7a,0x31,0x39,0x71,0x12,0x18,0xb9,0xbe,0x33,0x10,0xcf,0x1b,0x65,0xcb,0xc1,0x73},  
    /*TST_GeneratorSize;*/
    128*sizeof(DxUint8_t),
    /*TST_Prime - P*/
    {0xc4,0xac,0x0a,0xd9,0x6a,0xf5,0xb1,0x93,0x46,0x43,0xac,0x5b,0x2e,0x45,0x38,0x29,
    0x4e,0x24,0xde,0x8f,0x80,0x28,0x6c,0x4a,0xef,0xcb,0xc2,0x07,0xe5,0xae,0xec,0x4f,
    0x9a,0x1b,0x1b,0x61,0x35,0xdb,0xf9,0x88,0x83,0x61,0x4e,0xca,0x8e,0x82,0x43,0xf9,
    0x56,0x9f,0x4c,0xb0,0x28,0xbc,0xa9,0x9a,0x23,0x05,0xbd,0x08,0x7d,0xc6,0x3b,0x62,
    0x8f,0x2a,0x96,0x30,0xcf,0x29,0x6f,0x1c,0x18,0x54,0x57,0x9f,0xcb,0xf3,0xb0,0x85,
    0xb9,0xce,0xea,0xce,0x71,0x7a,0x16,0x05,0xb3,0xeb,0xf4,0xf6,0x99,0xd2,0x7c,0xe8,
    0x0e,0x36,0x01,0x3f,0x87,0x6c,0x4a,0xfc,0x45,0x67,0x09,0x5c,0xcb,0x09,0x9a,0x5b,
    0x96,0x61,0xd3,0x35,0x1a,0x04,0x07,0xa8,0x68,0xe4,0xc4,0xb1,0x3b,0x11,0xd7,0xa3},
    /*TST_PrimeSize*/
    128*sizeof(DxUint8_t),
    /*TST_Q*/
    {0xe8,0x13,0x1f,0x72,0x07,0x69,0x98,0x80,0x9e,0x2c,0x96,0xa7,0x2d,0xdd,0x7f,0x3d,
    0xe3,0x15,0xbb,0xe0,0xc1,0x8b,0x51,0xe7,0x96,0xe6,0x10,0x29,0x8c,0x79,0xa0,0xd7,
    0x49,0x2f,0xe6,0xe1,0xd1,0xac,0x57,0x56,0x46,0x89,0xfe,0xb4,0x6a,0xd5,0x37,0xb1,
    0x9f,0xd3,0xd5,0x29,0x63,0x94,0xf2,0x89,0xf3,0x39,0xa9,0xfd,0x3e,0xd4,0x70,0x96,
    0x2a,0x0d,0xc3,0xf7,0xf6,0xa0,0x1e,0xfb,0x24,0x4a,0xbe,0x15,0x6a,0xcd,0x13,0xfa,
    0x6b,0x5c,0x44,0x96,0xf4,0x1a,0xca,0xee,0x05,0xe1,0xe3,0x63,0xd2,0xe2,0x5e,0xa9,
    0x7f,0x67,0x46,0x7b,0xd3,0x60,0x72,0x83,0x28,0x27,0xad,0x3a,0xda,0x38,0x5e,0xfc,
    0xf2,0x1e,0x63,0x2c,0x44,0xa4,0x29,0xf1,0xa9,0xbb,0x73,0x68,0xf8,0x7b,0x01,0xdf},
    /*TST_QSize*/
    128*sizeof(DxUint8_t),      
    /*TST_hashFunc*/
    CE2_DH_HASH_SHA1_mode,
    /*TST_DerFunc_mode*/
    CE2_DH_ASN1_Der_mode,
    /*TST_KeyLenInBits*/
    192,          
    },
    { 
      {"Acceptance test - DH ANSI9.42/Prime-2048/Generator-2048/Q-2048/\n  DH_HASH_SHA1_mode/DH_ASN1_Der_mode"},
        /*TST_Generator - G*/
      {0xc9,0x16,0xa6,0x54,0x91,0xa7,0x1c,0xdf,0x9b,0xf9,0x59,0x07,0x95,0x06,0x4f,0xfa,
      0x95,0x79,0xc5,0x20,0x47,0xa4,0x75,0xce,0x49,0xb5,0x3c,0xfa,0x91,0xd4,0xd2,0xb5,
      0xe5,0x6b,0x36,0x24,0x5f,0x90,0x8e,0xfb,0x7a,0x1b,0x41,0xf7,0x18,0x41,0xfc,0x7b,
      0xa5,0xb4,0xc3,0xe1,0x71,0xb4,0x66,0x54,0x02,0x0a,0xd3,0xd9,0xd2,0x9d,0xe6,0x18,
      0x6d,0x2a,0xb7,0xdb,0x45,0xbe,0xc1,0x83,0x7f,0x94,0x5b,0xd7,0xd8,0x98,0xd2,0xcf,
      0x54,0x38,0x39,0xda,0x90,0x86,0xcc,0xab,0x0f,0x15,0xf8,0xb8,0xbf,0xde,0x50,0x07,
      0x74,0x45,0x84,0x4c,0x2f,0x08,0xb1,0x2f,0x40,0x49,0x9c,0xaf,0xb6,0xd1,0x6c,0xe3,
      0x45,0xbf,0xf1,0x63,0xcc,0x77,0x66,0x5d,0x45,0x35,0xb9,0x0a,0xac,0x74,0x14,0x91,
      0x64,0x1b,0x34,0x50,0xb4,0xa0,0x1e,0xd9,0xa9,0x62,0x56,0x57,0xcb,0x73,0x3c,0x96,
      0x5f,0x86,0x7f,0xc3,0x66,0xbf,0xac,0x79,0x21,0x51,0x14,0x3f,0x37,0x29,0xbe,0x96,
      0xc8,0xee,0xf1,0xaf,0x4e,0xc7,0x9f,0x83,0x20,0xe7,0xb5,0xb2,0x52,0x57,0xcc,0xa8,
      0xb0,0xf2,0x4d,0x88,0x3e,0x71,0xfb,0xd7,0x45,0x4d,0x96,0x0b,0xcb,0x24,0x0a,0x88,
      0x4f,0xaf,0xe8,0x96,0x79,0x87,0x14,0xf8,0x1e,0x3d,0xf7,0x2c,0x48,0xf7,0x0e,0x52,
      0x4e,0x3d,0xcb,0xeb,0x57,0x54,0xb9,0x90,0xe1,0x14,0x5c,0x36,0x7d,0xc0,0xa3,0x5f,
      0xf4,0xfd,0xf6,0x33,0x23,0x7e,0xf2,0xd0,0xff,0x0d,0xe0,0xe2,0xa3,0xcc,0x81,0x86,
      0xbc,0xde,0x67,0x83,0x03,0xd6,0xfa,0x5b,0x42,0xd3,0x1f,0xfe,0xd2,0x0f,0x2b,0x1b},  
      /*TST_GeneratorSize;*/
      256*sizeof(DxUint8_t),
      /*TST_Prime - P*/
      {0xce,0xd3,0x02,0x09,0x7d,0xe5,0x34,0xf5,0x3f,0x14,0x2e,0x7b,0x3e,0x15,0x4c,0x66,
      0x2c,0xe1,0xf0,0xb7,0x40,0x72,0x68,0xfa,0xad,0xa6,0xd5,0xd9,0x55,0x1e,0x7e,0xfd,
      0x06,0xbc,0x4f,0xb8,0x27,0xe9,0x22,0x3d,0x17,0xfa,0x4d,0x8c,0x8b,0x8e,0xce,0xf6,
      0xc9,0x49,0x38,0x74,0xa2,0x77,0x3b,0x9a,0xe1,0xc0,0xa7,0xc8,0x83,0xf9,0xdc,0xa7,
      0x9a,0x12,0xc5,0x19,0x5c,0xfb,0x40,0x0c,0x08,0x57,0xa1,0xf7,0x8d,0xf2,0x10,0x83,
      0xe8,0xe7,0x8a,0xc1,0x0c,0x59,0xa1,0xa3,0x77,0xb1,0x9f,0x0d,0x0f,0xf8,0x27,0xdd,
      0xdc,0xed,0xbf,0x04,0x91,0xa3,0x00,0x19,0x08,0x2d,0x7c,0xc9,0xda,0xfb,0x05,0x31,
      0xf5,0x34,0x0d,0xaa,0xd3,0xbb,0xc0,0x5b,0xfb,0xad,0x32,0x6b,0x98,0x00,0x17,0x01,
      0x39,0x61,0x0e,0x03,0x2e,0xf6,0x60,0x30,0x7b,0xb9,0xeb,0x39,0x60,0x1b,0xc4,0x7f,
      0xe5,0xcb,0x5f,0xc3,0xb0,0x79,0xdb,0x04,0xd2,0x9a,0x11,0x95,0x3e,0xa4,0x33,0x61,
      0x8e,0x94,0x22,0x9b,0x0a,0xd0,0xfb,0xda,0x07,0xc7,0x34,0xfb,0xa9,0x94,0xc8,0x31,
      0x03,0xe1,0x92,0xac,0x86,0xfc,0x45,0xe3,0x79,0x0b,0x9e,0x29,0x63,0xe8,0xcf,0x26,
      0x05,0xb3,0x6e,0xa9,0xae,0x9d,0xe3,0xdc,0x03,0x43,0x26,0xdf,0x7e,0x8b,0xae,0xcb,
      0xe8,0x09,0x04,0x25,0xdd,0x42,0xb8,0x59,0x44,0xec,0xc1,0xc7,0xbf,0x78,0x50,0x31,
      0xec,0x6e,0xa5,0x5f,0xe4,0x4f,0x79,0x7b,0xf3,0xbf,0x03,0xd3,0xa9,0x7b,0x7c,0x70,
      0xa2,0x5f,0xdb,0x86,0x96,0xfa,0xd1,0x3f,0x43,0xc5,0xd2,0x2a,0xf8,0xf3,0x3c,0x7b},
      /*TST_PrimeSize*/
      256*sizeof(DxUint8_t),
      /*TST_Q*/
      {0xa6,0x41,0x91,0x80,0xec,0x00,0x60,0xfb,0x23,0xd5,0x97,0xd3,0xf6,0x23,0xf5,0x79,
      0x73,0x16,0x0e,0x5a,0x3b,0x60,0x98,0x45,0x24,0xca,0xbb,0x72,0x91,0x9a,0xb8,0xda,
      0xe7,0x2c,0x0c,0xfe,0x70,0xf7,0x8a,0xbd,0xcc,0x11,0x8d,0x19,0x2e,0xc8,0x4d,0x1a,
      0x9e,0x60,0x03,0x96,0x01,0xe3,0x4c,0xd4,0xca,0xad,0xf0,0x51,0x4c,0xa5,0xe1,0x62,
      0xf2,0x5a,0x70,0x7d,0x89,0x0e,0x80,0x4b,0x53,0xa8,0x99,0xd5,0x6b,0x01,0xa5,0x66,
      0x93,0x42,0xc0,0x16,0x8f,0xfa,0x88,0xe9,0x6c,0xda,0x1e,0xa3,0xf7,0x71,0x13,0x00,
      0xda,0xbe,0x4a,0xaf,0xdd,0x2e,0x74,0xf9,0x14,0xdd,0xdb,0xe6,0xaf,0xa0,0x8e,0x1f,
      0x1b,0x3a,0xda,0x64,0xf2,0xc9,0x16,0x26,0x64,0xb8,0xd9,0x33,0x06,0xa7,0xb2,0x8d,
      0x19,0x1d,0x08,0xe9,0x5c,0x52,0xdc,0x28,0x49,0xdf,0xc6,0xb7,0x3e,0x02,0xbf,0xeb,
      0x2e,0x2a,0x77,0xec,0x9c,0x86,0xdc,0x5a,0xa0,0x59,0x0b,0x7a,0xdb,0x1a,0x0c,0xab,
      0x79,0x34,0x31,0xde,0xda,0xa1,0x2a,0x99,0x7c,0x27,0x49,0xcd,0x86,0xe8,0x00,0xb1,
      0xdd,0x8f,0x92,0xa3,0x1c,0x89,0xec,0x5d,0x50,0xe0,0xbe,0x90,0x5a,0xd8,0xa2,0x75,
      0x1b,0x95,0x5b,0xfd,0xf7,0x98,0x90,0xa9,0x60,0x63,0xf7,0xaf,0x38,0x7a,0x1c,0xce,
      0xc2,0xd2,0x2f,0xa0,0x6c,0x33,0x62,0xda,0x7e,0x43,0x93,0xb7,0x32,0x82,0xf8,0x03,
      0x77,0x49,0x26,0x4f,0x9d,0x88,0x67,0x85,0x91,0x63,0xf0,0x4d,0xd2,0x76,0xb1,0x8c,
      0x92,0x8a,0xd5,0x70,0xc9,0x35,0x59,0xab,0x42,0xaa,0xe1,0x9a,0xc0,0x64,0xc2,0x87},
      /*TST_QSize*/
      256*sizeof(DxUint8_t),  
      /*TST_hashFunc*/
      CE2_DH_HASH_SHA1_mode,
      /*TST_DerFunc_mode*/
      CE2_DH_ASN1_Der_mode,
      /*TST_KeyLenInBits*/
      256,                  
    },
};

const int TST_NumberOf_DH_PKCS3_AcceptanceTests = sizeof(TST_DH_Acceptance_PKCS3_TestDataStruct)/sizeof(TST_DH_Acceptance_PKCS3_TestDataStruct[0]); 
const int TST_NumberOf_DH_ANSI942_AcceptanceTests = sizeof(TST_DH_Acceptance_ANSI942_TestDataStruct)/sizeof(TST_DH_Acceptance_ANSI942_TestDataStruct[0]);

/************* Private function prototype ***********************/
/************************ Public Functions ******************************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_DH_Acceptance_ANSI9_42 		
* 
* Inputs:
* 	out - pointer to output log file;
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for the Diffie-Hellman key agreement 
*  schemes according to ANSI9.42 
*  using two methods for getting the secret data 
*  and using two methods for key derivation
* 	Prime sizes used (in bits) - 512/1024/2048									
* 	Generator sizes used (in bits) - 512/1024/2048
* 	Q sizes used (in bits) - 512/1024/2048
*  Derived Key sizes (in bits) - 128/192/256
*
* Algorithm:		
* 1. Call the CE2_DH_ANSI_X942_GeneratePubPrv function to 
*    generate a public and privet key for the client
* 2. Call the CE2_DH_ANSI_X942_GeneratePubPrv function to 
*    generate a public and privet key for the Server
* 3. Repete steps 1 & 2 in case of Hybrid scheam
* 4. Call the CE2_DH_X942_GetSecret_ASN1_2_Data
*             or 
* 	       CE2_DH_X942_GetSecret_Concat_2_Data
*             and in case of Hybrid scheam
*             CE2_DH_X942_Hybrid_GetSecret_ASN1_2_Data
*             or 
*             CE2_DH_X942_Hybrid_GetSecret_Concat_2_Data
*     both for the server and the Client to generate the secret keys
* 5. Compare the two secret keys - to verify they are identical													
*
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_Acceptance_ANSI942(FILE* out)
{
  int          TST_Index,TST_KeyGetSecretKeyType, TST_SecretDataGenType, i;
  CE2Error_t  TST_TestStatus = 0, error;
  int cmp_result;

  static DxUint8_t                  TST_ClientPrvKey1[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ClientPrvKeySize1;
  static DxUint8_t                  TST_ClientPrvKey2[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ClientPrvKeySize2;  
  static DxUint8_t                  TST_ClientPubKey1[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ClientPubKeySize1;
  static DxUint8_t                  TST_ClientPubKey2[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ClientPubKeySize2;  
  static DxUint8_t                  TST_ServerPrvKey1[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ServerPrvKeySize1;
  static DxUint8_t                  TST_ServerPrvKey2[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ServerPrvKeySize2;  
  static DxUint8_t                  TST_ServerPubKey1[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ServerPubKeySize1;
  static DxUint8_t                  TST_ServerPubKey2[TST_MAX_DH_KEY_SIZE]; 
  static DxUint16_t                 TST_ServerPubKeySize2;  
  static DxUint8_t                  TST_ClientSecretKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ClientSecretKeySize;
  static DxUint8_t                  TST_ServerSecretKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ServerSecretKeySize;

  PrintTestBeginMsg(out, __FUNCTION__);

  for (TST_SecretDataGenType = 0; TST_SecretDataGenType < TST_DH_SECRET_DATA_GEN_TYPES ;TST_SecretDataGenType++)
  { 
    for (TST_KeyGetSecretKeyType =0 ;TST_KeyGetSecretKeyType < TST_DH_ANSI924_DERIVATION_MODES ; TST_KeyGetSecretKeyType++) 
    {   
      for (TST_Index = 0 ;TST_Index < TST_NumberOf_DH_ANSI942_AcceptanceTests ; TST_Index++)
      {       
        /* Generating Keys for the Client side */
        /*-------------------------------------*/  
        TST_ClientPrvKeySize1 = TST_ClientPubKeySize1 = 
          TST_ClientPrvKeySize2 = TST_ClientPubKeySize2 =
          TST_ServerPrvKeySize1 = TST_ServerPubKeySize1 =  
          TST_ServerPrvKeySize2 = TST_ServerPubKeySize2 = TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize;

        error = CE2_DH_ANSI_X942_GeneratePubPrv(TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Generator, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_GeneratorSize, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Q, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_QSize, 
          TST_ClientPrvKey1,&TST_ClientPrvKeySize1,
          TST_ClientPubKey1,&TST_ClientPubKeySize1); 
        if (error != CE2_OK) {
          fprintf(out, "Can't generating Keys for the Client side.");
          fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
          TST_TestStatus |= error;
          continue;
        }


        /* Generating Keys for the Server side */
        /*-------------------------------------*/   
        error = CE2_DH_ANSI_X942_GeneratePubPrv(TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Generator, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_GeneratorSize, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Q, 
          TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_QSize, 
          TST_ServerPrvKey1,&TST_ServerPrvKeySize1,
          TST_ServerPubKey1,&TST_ServerPubKeySize1); 
        if (error != CE2_OK) {
          fprintf(out, "Can't generating Keys for the Server side.");
          fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
          TST_TestStatus |= error;
          continue;
        }


        /* Generating another Pair of Secret Keys both for Client and Serve */
        /* In case of working with Hybrid mode                              */
        /*------------------------------------------------------------------*/
        if (TST_SecretDataGenType == TST_DH_HYBRID_MODE)
        {
          /* Generating Keys #2 for the Client side */
          /*----------------------------------------*/    
          error = CE2_DH_ANSI_X942_GeneratePubPrv(TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Generator, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_GeneratorSize, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Q, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_QSize, 
            TST_ClientPrvKey2,&TST_ClientPrvKeySize2,
            TST_ClientPubKey2,&TST_ClientPubKeySize2); 
          if (error != CE2_OK) {
            fprintf(out, "Can't Generating Keys #2 for the Client side.");
            fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
            TST_TestStatus |= error;
            continue;
          }

          /* Generating Keys #2 for the Server side */
          /*----------------------------------------*/    
          error = CE2_DH_ANSI_X942_GeneratePubPrv(TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Generator, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_GeneratorSize, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Q, 
            TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_QSize, 
            TST_ServerPrvKey2,&TST_ServerPrvKeySize2,
            TST_ServerPubKey2,&TST_ServerPubKeySize2); 
          if (error != CE2_OK) {
            fprintf(out, "Can't Generating Keys #2 for the Server side.");
            fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
            TST_TestStatus |= error;
            continue;
          }

        }

        TST_ClientSecretKeySize = TST_ServerSecretKeySize = TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_KeyLenInBits;

        if (TST_SecretDataGenType == TST_DH_NON_HYBRID_MODE)
        {
          if (TST_KeyGetSecretKeyType == TST_DH_GET_SECRET_KEY_ASN1)
          {
            /* Generating Secret key for the Client */
            /*--------------------------------------*/
            error = CE2_DH_X942_GetSecret_ASN1_2_Data(
              CE2_DH_HASH_SHA1_mode,
              TST_ClientPrvKey1,TST_ClientPrvKeySize1, 
              TST_ServerPubKey1,TST_ServerPubKeySize1, 
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize,
              TST_ClientSecretKey, 
              TST_ClientSecretKeySize);
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Client.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }

            /* Generating Secret key for the Server */
            /*--------------------------------------*/
            error = CE2_DH_X942_GetSecret_ASN1_2_Data(
              CE2_DH_HASH_SHA1_mode,
              TST_ServerPrvKey1,TST_ServerPrvKeySize1, 
              TST_ClientPubKey1,TST_ClientPubKeySize1, 
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize,
              TST_ServerSecretKey, 
              TST_ServerSecretKeySize);
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Server.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }
          }
          else
          {
            /* Generating Secret key for the Client */
            /*--------------------------------------*/                  
            error = CE2_DH_X942_GetSecret_Concat_2_Data(
              CE2_DH_HASH_SHA1_mode,
              TST_ClientPrvKey1,TST_ClientPrvKeySize1,
              TST_ServerPubKey1,TST_ServerPubKeySize1,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime, 
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize, 
              TST_ClientSecretKey,
              TST_ClientSecretKeySize); 
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Client.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }

            /* Generating Secret key for the Server */
            /*--------------------------------------*/                  
            error = CE2_DH_X942_GetSecret_Concat_2_Data(
              CE2_DH_HASH_SHA1_mode,
              TST_ServerPrvKey1,TST_ServerPrvKeySize1,
              TST_ClientPubKey1,TST_ClientPubKeySize1,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime, 
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize, 
              TST_ServerSecretKey,
              TST_ServerSecretKeySize); 
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Server.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }

          }
        }
        else
        {
          if (TST_KeyGetSecretKeyType == TST_DH_GET_SECRET_KEY_ASN1)
          {
            /* Generating Secret key for the Client */
            /*--------------------------------------*/                      
            error = CE2_DH_X942_Hybrid_GetSecret_ASN1_2_Data(
              CE2_DH_HASH_SHA1_mode,
              TST_ClientPrvKey1,TST_ClientPrvKeySize1,
              TST_ClientPrvKey2,TST_ClientPrvKeySize2,
              TST_ServerPubKey1,TST_ServerPubKeySize1,
              TST_ServerPubKey2,TST_ServerPubKeySize2,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize,
              TST_ClientSecretKey,
              TST_ClientSecretKeySize);
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Client.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }

            /* Generating Secret key for the Server */
            /*--------------------------------------*/                      
            error = CE2_DH_X942_Hybrid_GetSecret_ASN1_2_Data(
              CE2_DH_HASH_SHA1_mode,
              TST_ServerPrvKey1,TST_ServerPrvKeySize1,
              TST_ServerPrvKey2,TST_ServerPrvKeySize2,
              TST_ClientPubKey1,TST_ClientPubKeySize1,
              TST_ClientPubKey2,TST_ClientPubKeySize2,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize,
              TST_ServerSecretKey,
              TST_ServerSecretKeySize);
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Server.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }
          }
          else
          {
            /* Generating Secret key for the Client */
            /*--------------------------------------*/                      
            error = CE2_DH_X942_Hybrid_GetSecret_Concat_2_Data(
              CE2_DH_HASH_SHA1_mode,
              TST_ClientPrvKey1,TST_ClientPrvKeySize1,
              TST_ClientPrvKey2,TST_ClientPrvKeySize2,
              TST_ServerPubKey1,TST_ServerPubKeySize1,
              TST_ServerPubKey2,TST_ServerPubKeySize2,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize,
              TST_ClientSecretKey,TST_ClientSecretKeySize);
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Client.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }


            /* Generating Secret key for the Server */
            /*--------------------------------------*/                      
            error = CE2_DH_X942_Hybrid_GetSecret_Concat_2_Data(
              CE2_DH_HASH_SHA1_mode, 
              TST_ServerPrvKey1,TST_ServerPrvKeySize1,
              TST_ServerPrvKey2,TST_ServerPrvKeySize2,
              TST_ClientPubKey1,TST_ClientPubKeySize1,
              TST_ClientPubKey2,TST_ClientPubKeySize2,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime,
              TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize,
              TST_ServerSecretKey,TST_ServerSecretKeySize);
            if (error != CE2_OK) {
              fprintf(out, "Can't Generating Secret key for the Server.");
              fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  
              TST_TestStatus |= error;
              continue;
            }
          }               
        }

        /* Verifying we have the same Secret Key both for client & Server */
        /*----------------------------------------------------------------*/                                                    
        cmp_result = memcmp(TST_ServerSecretKey ,
          TST_ClientSecretKey,
          (TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_KeyLenInBits)/8);  
        if (cmp_result != 0) {
          fprintf(out, "Secret Key for client & Server are different.");
          fprintf(out, " %s[test %d]\n", TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name, TST_Index);  

          fprintf(out, "\n");
          for(i = 0; i < TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_KeyLenInBits/8; i++) {
            fprintf(out, "%X", (TST_ServerSecretKey[i]/0x10));
            fprintf(out, "%X ", (TST_ServerSecretKey[i])&0x0F);
          }
          fprintf(out, "\n");

          fprintf(out, "\n");
          for(i = 0; i < TST_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_KeyLenInBits/8; i++) {
            fprintf(out, "%X", (TST_ClientSecretKey[i]/0x10));
            fprintf(out, "%X ", (TST_ClientSecretKey[i])&0x0F);
          }
          fprintf(out, "\n");

          TST_TestStatus |= cmp_result;
          continue;
        }

      }/*End of TST_Index loop*/                                  
    }/*End of TST_KeyDerivationMode loop */ 
  }/*End of TST_SecretDataGenType loop*/

  PrintTestEndMsg(out, __FUNCTION__, TST_TestStatus);

  return TST_TestStatus;                          
}

/*****************************************************************************
* Function Name:                                                           
*  CE2_ATP_TST_DH_Acceptance_PKCS3        
*  
* Inputs:
*  None
*
* Outputs: 
*  CE2Error_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for the Diffie-Hellman key agreement 
*  scheme according to PKCS#3  
*  Prime sizes used (in bits) - 512/1024/2048                                  
*  Generator sizes used (in bits) - 512/1024/2048
*  L sizes used - 10/11/12 
*
* Algorithm:       
* 1. Call the CE2_DH_PKCS3_GeneratePubPrv function to 
*    generate a public and privet key for the client
* 2. Call the CE2_DH_PKCS3_GeneratePubPrv function to 
*    generate a public and privet key for the Server
* 3. Call the CE2_DH_PKCS3_GetSecretKey function to 
*    generate a secret key for the client  
* 4. Call the CE2_DH_PKCS3_GetSecretKey function to 
*    generate a secret key for the Server
* 5. Compare the two secret keys - to verify they are identical                                                    
*
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_Acceptance_PKCS3(FILE *out)
{
  int TST_Index, cmp_result, i; 
  CE2Error_t  TST_TestStatus = 0, error;

  static DxUint8_t                  TST_ClientPrvKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ClientPrvKeySize;
  static DxUint8_t                  TST_ClientPubKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ClientPubKeySize;
  static DxUint8_t                  TST_ServerPrvKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ServerPrvKeySize;
  static DxUint8_t                  TST_ServerPubKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ServerPubKeySize;   
  static DxUint8_t                  TST_ClientSecretKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ClientSecretKeySize;
  static DxUint8_t                  TST_ServerSecretKey[TST_MAX_DH_KEY_SIZE];
  static DxUint16_t                 TST_ServerSecretKeySize;        

  PrintTestBeginMsg(out, __FUNCTION__);

  for (TST_Index = 0 ;TST_Index < TST_NumberOf_DH_PKCS3_AcceptanceTests ; TST_Index++)
  {       
    /* Generating Keys for the Client side */
    /*-------------------------------------*/   
    TST_ClientPrvKeySize = TST_ClientPubKeySize = TST_ServerPrvKeySize = TST_ServerPubKeySize =  TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_PrimeSize;

    error =  CE2_DH_PKCS3_GeneratePubPrv(TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Generator,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_GeneratorSize,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Prime,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_PrimeSize,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_L,
      TST_ClientPrvKey,&TST_ClientPrvKeySize,
      TST_ClientPubKey,&TST_ClientPubKeySize);
    if (error != CE2_OK) {
      fprintf(out, "Can't Generating Keys for the Client side.");
      fprintf(out, " %s[test %d]\n", 
        TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Name, TST_Index);  
      TST_TestStatus |= error;
      continue;
    }

    /* Generating Keys for the Server side */
    /*-------------------------------------*/   
    error =  CE2_DH_PKCS3_GeneratePubPrv(TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Generator,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_GeneratorSize,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Prime,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_PrimeSize,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_L,
      TST_ServerPrvKey,&TST_ServerPrvKeySize,
      TST_ServerPubKey,&TST_ServerPubKeySize);
    if (error != CE2_OK) {
      fprintf(out, "Can't Generating Keys for the Server side.");
      fprintf(out, " %s[test %d]\n", 
        TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Name, TST_Index);  
      TST_TestStatus |= error;
      continue;
    }

    /* Generating Secret Key for the client side */ 
    /*-------------------------------------------*/ 
    TST_ServerSecretKeySize = TST_ClientSecretKeySize = TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_PrimeSize;

    error =  CE2_DH_PKCS3_GetSecretKey(TST_ClientPrvKey,
      TST_ClientPrvKeySize,
      TST_ServerPubKey,
      TST_ServerPubKeySize,                                   
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Prime,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_PrimeSize,
      TST_ClientSecretKey,&TST_ClientSecretKeySize);      
    if (error != CE2_OK) {
      fprintf(out, "Can't Generating Secret Key for the client side.");
      fprintf(out, " %s[test %d]\n", 
        TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Name, TST_Index);  
      TST_TestStatus |= error;
      continue;
    }

    /* Generating Secret Key for the server side */ 
    /*-------------------------------------------*/ 
    error =  CE2_DH_PKCS3_GetSecretKey(TST_ServerPrvKey,
      TST_ServerPrvKeySize,
      TST_ClientPubKey,
      TST_ClientPubKeySize,                                   
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Prime,
      TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_PrimeSize,
      TST_ServerSecretKey,&TST_ServerSecretKeySize);      
    if (error != CE2_OK) {
      fprintf(out, "Can't Generating Secret Key for the server side.");
      fprintf(out, " %s[test %d]\n", 
        TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Name, TST_Index);  
      TST_TestStatus |= error;
      continue;
    }

    /* Verifying we have the same Secret Key both for client & Server */
    /*----------------------------------------------------------------*/                                                    
    cmp_result = memcmp(TST_ServerSecretKey ,
      TST_ClientSecretKey,
      TST_ServerSecretKeySize);   
    if (cmp_result != 0) {
      fprintf(out, "Secret keys for server and client are different!");
      fprintf(out, " %s[test %d]\n", 
        TST_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Name, TST_Index); 

      fprintf(out, "\n");
      for(i = 0; i < TST_ServerSecretKeySize; i++) {
        fprintf(out, "%X", (TST_ServerSecretKey[i]/0x10));
        fprintf(out, "%X ", (TST_ServerSecretKey[i])&0x0F);
      }
      fprintf(out, "\n");

      fprintf(out, "\n");
      for(i = 0; i < TST_ClientSecretKeySize; i++) {
        fprintf(out, "%X", (TST_ClientSecretKey[i]/0x10));
        fprintf(out, "%X ", (TST_ClientSecretKey[i])&0x0F);
      }
      fprintf(out, "\n");

      TST_TestStatus |= cmp_result;
      continue;
    }
  }/* End of TST_Index loop*/ 

  PrintTestEndMsg(out, __FUNCTION__, TST_TestStatus);

  return TST_TestStatus;                          
}
